package dtu.library.app;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import org.junit.Test;


public class TestManageUsers extends SampleDataSetup {
	
	/** 
	 * Tests the deletion of a book from the library. The book is identified by its 
	 * signature.
	 * This is again an operation only
	 * the administrator is allowed to do; thus the administrator has to log in first.
	 * <ol>
	 * 	<li>Checks that the library contains the book to be deleted.
	 * 	<li>Administrator logs in
	 * 	<li>Deletes the book in the library
	 * 	<li>Checks that the book is deleted and that only one book has been removed.
	 * @throws Exception 
	 */ 
	@Test
	public void testUnregisterUser() throws Exception {
		String cpr = "1234651234";
		
		User user = libApp.userByCprNumber(cpr);
		assertNotNull(user);
		
		libApp.adminLogin("adminadmin");
		
		libApp.unregister(cpr);

		user = libApp.userByCprNumber(cpr);
		assertNull(user);
	}

	/** 
	 * Tests the deletion of a book from the library when the administrator
	 * is not logged in. In this case, an OperationNotAllowedException should be
	 * thrown.
	 * <ol>
	 * 	<li>Checks that the administrator is not logged in.
	 * 	<li>Tries to delete an existing book from the library.
	 * 	<li>Checks that an exception with the correct values is thrown.
	 */ 
	@Test
	public void testDeleteBookAdminCheckedIn() {
		String cpr = "1234651234";
		
		User user = libApp.userByCprNumber(cpr);
		assertNotNull(user);
		
		user = libApp.userByCprNumber(cpr);
		assertNotNull(user);
		
		libApp.adminLogoff();

		assertFalse(libApp.adminLoggedIn());

		try {
			libApp.unregister(cpr);
			fail("An OperationNotAllowedException should have been thrown");
		}  catch (OperationNotAllowedException e) {
			// Step 3)
			
			assertEquals("Unregister user operation not allowed if not admin.",e.getMessage());
			assertEquals("Unregister user",e.getOperation());
		}
		
		user = libApp.userByCprNumber(cpr);
		assertNotNull(user);
	}
}
