package dtu.library.app;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;


public class TestLoginLogout {
	/**
	 * Test administrator log out
	 * <ol>
	 * 	<li>The administrator logs in
	 * 	<li>Check that the administrator is logged in
	 * 	<li>The administrator logs otu
	 * 	<li>Check that the administrator is looged out
	 * </ol>
	 */
	@Test
	public void testLogout() {
		LibraryApp libApp = new LibraryApp();
		
		// Check first that the administrator is not logged in.
		
		assertFalse(libApp.adminLoggedIn());
		
		// Step 1)
		
		libApp.adminLogin("adminadmin");
		
		// Step 2) Check that the administrator is logged in.
		assertTrue(libApp.adminLoggedIn());
		
		// Step 4) The administrator logs out

		libApp.adminLogoff();
		
		// Step 4) Check that the administrator is not logged in
		assertFalse(libApp.adminLoggedIn());
	
		
	}
}
