package dtu.library.app;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.junit.Before;
import org.junit.Test;

public class TestFine extends SampleDataSetup {

	User user;
	Calendar cal;
	DateServer dateServer = mock(DateServer.class);

	@Override
	@Before
	public void setUp() throws Exception {
		super.setUp();
		// Step 1
		dateServer = mock(DateServer.class);
		libApp.setDateServer(dateServer);

		cal = new GregorianCalendar();
		cal.set(2011, Calendar.JANUARY, 10);
		when(dateServer.getDate()).thenReturn(cal);

		String cprNumber = "1234651234";
		user = libApp.userByCprNumber(cprNumber);

	}

	@Test
	public void testFineForOverdueBook() throws Exception {
		String signature = "Som001";
		Medium book = libApp.mediaBySignature(signature);

		user.borrowMedium(book);
		assertEquals(0, user.getFine());

		Calendar newCal = new GregorianCalendar();
		newCal.setTime(cal.getTime());
		newCal.add(Calendar.DAY_OF_YEAR,
				SampleDataSetup.MAX_DAYS_FOR_BOOK_LOAN + 1);
		when(dateServer.getDate()).thenReturn(newCal);

		assertTrue(book.isOverdue());
		assertEquals(20, user.getFine());

		user.returnMedia(book);
		assertEquals(0, user.getFine());
	}

	@Test
	public void testFineFor2OverdueBook() throws Exception {
		String signature = "Som001";
		Medium book = libApp.mediaBySignature(signature);

		user.borrowMedium(book);
		assertEquals(0, user.getFine());

		Medium book2 = libApp.mediaBySignature("book1");
		user.borrowMedium(book2);

		Calendar newCal = new GregorianCalendar();
		newCal.setTime(cal.getTime());
		newCal.add(Calendar.DAY_OF_YEAR,
				SampleDataSetup.MAX_DAYS_FOR_BOOK_LOAN + 1);
		when(dateServer.getDate()).thenReturn(newCal);

		assertTrue(book.isOverdue());
		assertTrue(book2.isOverdue());
		assertEquals(40, user.getFine());

		user.returnMedia(book);
		assertEquals(20, user.getFine());
		user.returnMedia(book2);
		assertEquals(0, user.getFine());
	}
	
	@Test
	public void testFineForOverdueCd() throws Exception {
		String signature = "CD1";
		Medium cd = libApp.mediaBySignature(signature);

		user.borrowMedium(cd);
		
			assertEquals(0,user.getFine());

			Calendar newCal = new GregorianCalendar();
			newCal.setTime(cal.getTime());
			newCal.add(Calendar.DAY_OF_YEAR, SampleDataSetup.MAX_DAYS_FOR_CD_LOAN + 1);
			when(dateServer.getDate()).thenReturn(newCal);

			assertTrue(cd.isOverdue());
			assertEquals(40,user.getFine());

			user.returnMedia(cd);
			assertEquals(0,user.getFine());
	}


}
