package dtu.library.app;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.junit.Test;


public class TestEMailReminder extends SampleDataSetup {
	@Test
	public void testEMailReminder() throws Exception {
		
		MailService ms = mock(MailService.class);
		libApp.setMailService(ms);
		DateServer dateServer = mock(DateServer.class);
		libApp.setDateServer(dateServer);

		Calendar cal = new GregorianCalendar(2011,Calendar.JANUARY,10);
		when(dateServer.getDate()).thenReturn(cal);

		String cprNumber = "1234651234";
		User user = libApp.userByCprNumber(cprNumber);

		String signature = "Som001";
		Medium book = libApp.mediaBySignature(signature);

		user.borrowMedium(book);

		Calendar newCal = new GregorianCalendar();
		newCal.setTime(cal.getTime());
		newCal.add(Calendar.DAY_OF_YEAR, 28+1);
		when(dateServer.getDate()).thenReturn(newCal);

		// Step 5
		assertTrue(book.isOverdue());
		
		libApp.sendEMailReminder();

		String email = user.getEmail();
		String subject = "Overdue book(s)";
		String text = "You have 1 overdue book(s)";
		verify(ms).send(email,subject,text);

	}
}
