package dtu.library.app;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Test;

/**
 * This class contains tests, testing the functionality of adding books to the library.
 * @author hub
 *
 */
public class TestAddCd {
	@Test
	public void testAdminAddCd() throws Exception {
		
		LibraryApp libApp = new LibraryApp();
		
		// Check first the initial state of the library and the library application.
		// a) The library has no books.
		// b) The administrator is not logged in.
		
		assertTrue(libApp.getMedia().isEmpty());
		assertFalse(libApp.adminLoggedIn());
		
		// Step 1)
		
		boolean login = libApp.adminLogin("adminadmin");
		
		// Check that the login was successful.
		// a) The method adminLogin returned true
		// b) The library applications knows that the administrator has logged in,
		//    by checking that libApp.adminLoggedIn() returns true
		
		assertTrue(login);
		assertTrue(libApp.adminLoggedIn());
		
		// Step 2)
				
		String signature = "CD1";
		String title = "Some CD title";
		String author = "Come CD author";
		
		Cd cd = new Cd(signature,title,author);
		
		// Step 3)
		
		libApp.addMedium(cd);
		
		// Check that the book was added to the library.
		// a) The library has now one book.
		// b) The book in the library has the correct title and author.

		List<Medium> media = libApp.getMedia();
		assertEquals(1,media.size());
		assertEquals(signature,media.get(0).getSignature());
		assertEquals(title,media.get(0).getTitle());
		assertEquals(author,media.get(0).getAuthor());
	}
}
