package dtu.library.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class User {
	
	private String cprNumber;
	private String name;
	private String email;
	private Address address;
	private List<Medium> borrowedMedia = new ArrayList<Medium>();
	
	private LibraryApp libApp;

	public User(String cprNumber, String name, String email, Address address) {
		this.cprNumber = cprNumber;
		this.name = name;
		this.email = email;
		this.address = address;
	}

	void setLibraryApp(LibraryApp libApp) {
		this.libApp = libApp;
	}
	
	public String getCprNumber() {
		return cprNumber;
	}

	public String getName() {
		return name;
	}

	public String getEmail() {
		return email;
	}

	public Address getAddress() {
		return address;
	}

	public List<Medium> getBorrowedMedia() {
		return Collections.unmodifiableList(borrowedMedia);
	}

	public void borrowMedium(Medium medium) throws BorrowException {
		if (medium == null) return;
		if (borrowedMedia.size() >= 10) {
			throw new TooManyBooksException();
		}
		for (Medium mdm :  borrowedMedia) {
			if (mdm.isOverdue()) {
				throw new HasOverdueMedia();
			}
		}
		medium.setBorrowDate(libApp.getDate());
		borrowedMedia.add(medium);
	}

	void returnMedia(Medium medium) {
		medium.resetBorrowedStatus();
		borrowedMedia.remove(medium);
	}
	
	public int getFine() {
		int fine = 0;
		for (Medium medium : borrowedMedia) {
			if (medium.isOverdue()) {
				fine += medium.getFine();
			}
		}
		return fine;
	}

}
