package dtu.library.app;

import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class Medium {
//	public static final int MAX_DAYS_FOR_LOAN = 7*4;

	private String signature;
	private String title;
	private String author;
	private Calendar borrowDate;
	private LibraryApp libApp;


	public Medium(String signature, String title, String author) {
		this.signature = signature;
		this.title = title;
		this.author = author;
	}
	
	void setLibraryApp(LibraryApp libApp)  {
		this.libApp = libApp;
	}
	
	public Medium() {};


	public void setSignature(String signature) {
		this.signature = signature;
	}

	public String getSignature() {
		return signature;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return title;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getAuthor() {
		return author;
	}

	void setBorrowDate(Calendar date) {
		borrowDate = date;
	}
	
	public boolean isOverdue() {
		if (!isBorrowed()) {
			return false;
		}
		Calendar date = libApp.getDate();
		Calendar latestReturnDate = new GregorianCalendar();
		latestReturnDate.setTime(borrowDate.getTime());
		latestReturnDate.add(Calendar.DAY_OF_YEAR, getMaxDaysForLoan());
		return latestReturnDate.before(date);
	}
	
	protected abstract int getMaxDaysForLoan();

	public boolean isBorrowed() {
		return borrowDate != null;
	}

	public void resetBorrowedStatus() {
		borrowDate = null;
		
	}
	
	public abstract int getFine();
}
