package dtu.se1;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class MyStack<E> extends Observable {
	List<E> data = new ArrayList<E>();

	public void push(E o) {
		data.add(o);
		setChanged();
		notifyObservers("data elements");
	}

	public E pop() {
		E top = data.remove(data.size() - 1);
		setChanged();
		notifyObservers("data elements");
		return top;
	}

	public E top() {
		return data.get(data.size() - 1);
	}

	public int size() {
		return data.size();
	}

	public String toString() {
		String str = "";
		if (data.isEmpty()) {
			return str;
		}
		for (int i = data.size() - 1; i >= 1; i--) {
			str += data.get(i) + ", ";
		}
		str += data.get(0);
		return str;
	}
}
